/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <windows.h>
#include <Commctrl.h>
#include <dinput.h>
#include "commonIncludes.h"
#include "NRage PluginV2.h"
#include "Interface.h"
#include "FileAcces.h"
#include "PakIO.h"
#include "DirectInput.h"


// ProtoTypes //
bool prepareHeap();
void freeControllerStruct( CONTROLLER *pcController );
int FindDeviceinList( TCHAR *pszProductName, BYTE bProductCounter, bool fFindSimilar );
void NotifyEmulator();
void InitiatePaks( bool bInitialize = false );
bool ErrorMessage( TCHAR *pszFirstLine, DWORD dwError, bool fUserChoose );

// Global Variables //
HMODULE g_hDirectInputDLL = NULL; // Handle to DirectInput8
HANDLE g_hHeap = NULL;
HINSTANCE g_hinstDll = NULL; // DLL-Handle
SHORTCUTS g_scShortcuts;
DEVICE g_devList[MAX_DEVICES]; //List of attached Game-Controllers

EMULATOR_INFO g_strEmuInfo;

CRITICAL_SECTION g_resController;
int g_iFirstController = -1;

bool g_bRunning = false;
bool g_bConfiguring = false;
bool g_bExclusiveMouse = false;
CONTROLLER g_pcControllers[4];




BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved )
{
	switch ( ul_reason_for_call )
	{
	case DLL_PROCESS_ATTACH:
		DisableThreadLibraryCalls( hModule );
		if( !prepareHeap())
			return FALSE;
		g_hinstDll = hModule;
		InitializeCriticalSection( &g_resController );
		break;

	case DLL_THREAD_ATTACH:
		break;

	case DLL_THREAD_DETACH:
		break;

	case DLL_PROCESS_DETACH:
		//CloseDLL();

		CloseDebugFile(); // Moved here from CloseDll
		DeleteCriticalSection( &g_resController );

		// Moved here from CloseDll... Heap is created from DllMain,
		// and now it's destroyed by DllMain... just safer code...
		if( g_hHeap != NULL )
		{
			HeapDestroy( g_hHeap );
			g_hHeap = NULL;
		}
		break;
	}
    return TRUE;
}


EXPORT void CALL GetDllInfo ( PLUGIN_INFO* PluginInfo )
{
	lstrcpynA( PluginInfo->Name, STRING_PLUGINNAME " " VERSIONINFO, sizeof( PluginInfo->Name ) );
	PluginInfo->Type = PLUGIN_TYPE_CONTROLLER;
	PluginInfo->Version = SPECS_VERSION;
}

EXPORT void CALL DllAbout ( HWND hParent )
{
	LPTSTR szText = STRING_PLUGINNAME "\n\n" \
		"Visit my Site for Support:  >>http://go.to/nrage<<\n\n" \
		"Version " VERSIONINFO " (" VERSIONDATE ")\n" \
		"Done by N-Rage\n" \
		"\n" \
		" - - - - -\n" \
		"Transferpak emulation done by MadManMarkAu";
	MessageBox( hParent, szText, TEXT("About Plugin"), MB_OK | MB_ICONINFORMATION);
	return;
}

EXPORT void CALL DllConfig ( HWND hParent )
{
	static bool bInitCC = false;
	if( !prepareHeap())
		return;

	if( !g_strEmuInfo.fInitialisedPlugin )
	{
		LoadShortCuts( &g_scShortcuts );
	}

	if( !g_pDIHandle )
	{
		if( InitDirectInput( hParent ))
		{
			int nDevices = 0;
			ZeroMemory( g_devList, sizeof(g_devList) );
			VOID *pGetDevListRef[2] = {	&nDevices,
										g_devList };
			g_pDIHandle->EnumDevices( DI8DEVCLASS_ALL, EnumMakeDeviceList, (VOID*)pGetDevListRef, DIEDFL_ATTACHEDONLY );
		}
	}

	if( g_pDIHandle && !g_bConfiguring )
	{	
		if( !bInitCC )
		{
			INITCOMMONCONTROLSEX ccCtrls =	{	sizeof(INITCOMMONCONTROLSEX), 
											ICC_BAR_CLASSES | ICC_TAB_CLASSES | ICC_LISTVIEW_CLASSES };
			InitCommonControlsEx( &ccCtrls ); // needed for TrackBars & Tabs
		}
		
		g_bConfiguring = true;
		if( DialogBox( g_hinstDll, MAKEINTRESOURCE( IDD_MAINCFGDIALOG ), hParent, MainDlgProc ) == 10 && g_bRunning )
		{
			EnterCriticalSection( &g_resController );
			PrepareInputDevices();
			InitiatePaks( false );
			NotifyEmulator();
			LeaveCriticalSection( &g_resController );
		}
		g_bConfiguring = false;
	}
	return;
}

EXPORT void CALL DllTest ( HWND hParent )
{
	return;
}

#if SPECS_VERSION == 0x0100
EXPORT void CALL InitiateControllers( HWND hMainWindow, CONTROL Controls[4])
{
	if( !prepareHeap())
		return;

	g_strEmuInfo.hMainWindow = hMainWindow;
	g_strEmuInfo.hinst = g_hinstDll;

	g_strEmuInfo.MemoryBswaped = false;
	g_strEmuInfo.HEADER = NULL;
	g_strEmuInfo.Controls = Controls;

	g_strEmuInfo.fInitialisedPlugin = true;

	LoadShortCuts( &g_scShortcuts );
	return;
}
#endif // #if SPECS_VERSION == 0x0100

#if SPECS_VERSION >= 0x0101
EXPORT void CALL InitiateControllers (CONTROL_INFO ControlInfo)
{
	if( !prepareHeap())
		return;

	g_strEmuInfo.hMainWindow = ControlInfo.hMainWindow;
	g_strEmuInfo.hinst = g_hinstDll;

	g_strEmuInfo.MemoryBswaped = ControlInfo.MemoryBswaped;
	g_strEmuInfo.HEADER = ControlInfo.HEADER;
	g_strEmuInfo.Controls = ControlInfo.Controls;

	g_strEmuInfo.fInitialisedPlugin = true;

	LoadShortCuts( &g_scShortcuts );
	return;
}
#endif // #if SPECS_VERSION >= 0x0101

EXPORT void CALL RomOpen (void)
{
#ifdef _DEBUG
	// Debug switch
	{ DWORD dwData, dwSize = sizeof(DWORD);
	if( LoadRegValue( NULL, 0, STRING_REG_AUTOCONFIG, &dwData, &dwSize ))
		bDebug = (dwData != 0); }
#endif // #ifdef _DEBUG

	if( !g_strEmuInfo.fInitialisedPlugin )
	{
		MessageBox( g_strEmuInfo.hMainWindow, "Plugin din`t got initialized!", PLUGINERROR, MB_OK | MB_ICONERROR );
		return;
	}

	if( !g_pDIHandle )
	{
		if( InitDirectInput( g_strEmuInfo.hMainWindow ))
		{
			int nDevices = 0;
			ZeroMemory( g_devList, sizeof(g_devList) );
			VOID *pGetDevListRef[2] = {	&nDevices,
										g_devList };
			g_pDIHandle->EnumDevices( DI8DEVCLASS_ALL, EnumMakeDeviceList, (VOID*)pGetDevListRef, DIEDFL_ATTACHEDONLY );
		}
		else
			return;
	}

	bool fAutoConfig = false;
	DWORD dwData, dwSize = sizeof(DWORD);
	if( LoadRegValue( NULL, 0, STRING_REG_AUTOCONFIG, &dwData, &dwSize ))
		fAutoConfig = (dwData != 0);

	// autocon ausschalten
	fAutoConfig = false;

	TCHAR szBuffer[MAX_PATH+1];
	BYTE bProductCounter;
	int iDevice;

	EnterCriticalSection( &g_resController );

	for( int i = 0; i < 4; i++ )
	{
		if( g_pcControllers[i].fPlugged )
		{
			SaveControllerPak( i );
			CloseControllerPak( i );
			freeControllerStruct( &g_pcControllers[i] );
		}

		ZeroMemory( &g_pcControllers[i], sizeof(CONTROLLER) );

		if( fAutoConfig )
			;
		else
		{
			LoadControllerStruct( &g_pcControllers[i], i );
		}


		if( g_pcControllers[i].fPlugged )
		{
			szBuffer[0] = '\0';
			bProductCounter = -1;

			if( fAutoConfig )
			{
			}
			else
			{
				LoadDeviceDesc( szBuffer, &bProductCounter, i );
			}

			// Search for right Controller
			ZeroMemory( &g_pcControllers[i].guidPadDevice, sizeof(GUID));
			g_pcControllers[i].dwDevType = 0;
			iDevice = FindDeviceinList( szBuffer, bProductCounter, true );
			if( iDevice != -1 )
			{
				g_pcControllers[i].guidPadDevice = g_devList[iDevice].guidInstance;
				g_pcControllers[i].dwDevType = g_devList[iDevice].dwDevType;
			}



			if( g_pcControllers[i].nModifiers > 0)
				SetModifier( &g_pcControllers[i] );
		}
		else
		{
			freeControllerStruct( &g_pcControllers[i] );
		}
	}

	PrepareInputDevices();
	InitiatePaks( true );
	NotifyEmulator();
	LeaveCriticalSection( &g_resController );
	g_bRunning = true;
	return;
}


EXPORT void CALL RomClosed(void)
{
	EnterCriticalSection( &g_resController );
	for( int i = 0; i < ARRAYSIZE(g_pcControllers); ++i )
	{
		if( g_pcControllers[i].fPlugged )
		{
			SaveControllerPak( i );
			CloseControllerPak( i );
		}
		freeControllerStruct( &g_pcControllers[i] );
		ZeroMemory( &g_pcControllers[i], sizeof(CONTROLLER) );
	}

	for( i = 0; i < ARRAYSIZE( g_apdiEffect ); ++i )
		ReleaseEffect( g_apdiEffect[i] );
	for( i = 0; i << ARRAYSIZE(g_apInputDevice); ++i )
		ReleaseDevice( g_apInputDevice[i] );

	LeaveCriticalSection( &g_resController );
	g_bRunning = false;
	
	return;
}

EXPORT void CALL GetKeys(int Control, BUTTONS * Keys )
{
	if( g_bConfiguring )
		Keys->Value = 0;
	else
	{
		EnterCriticalSection( &g_resController );
		if( g_iFirstController == Control )
			GetDeviceDatas();
		
		if( g_pcControllers[Control].fPlugged )
			GetNControllerInput( Control, &Keys->Value );
		LeaveCriticalSection( &g_resController );
	}
	return;
}

#ifndef USECONTROLLERCOMMAND
EXPORT void CALL ControllerCommand( int Control, BYTE * Command)
#else
EXPORT void CALL ReadController( int Control, BYTE * Command )
#endif
{
	return;
}
#ifndef USECONTROLLERCOMMAND
EXPORT void CALL ReadController( int Control, BYTE * Command )
#else
EXPORT void CALL ControllerCommand( int Control, BYTE * Command)
#endif
{
	if( Control == -1 )
		return;

	EnterCriticalSection( &g_resController );

	if( !g_pcControllers[Control].fPlugged )
	{
		Command[1] = Command[1] | RD_ERROR;
		LeaveCriticalSection( &g_resController );
		return;
	}

	
	switch( Command[2] )
	{
	case RD_RESETCONTROLLER:
		WriteDatasA( "ResetController-PreProcessing", Command, 0);
	case RD_GETSTATUS:
#ifdef ENABLE_GET_STATUS_DEBUG
		WriteDatasA( "GetStatus-PreProcessing", Command, 0);
#endif
		Command[3] = RD_GAMEPAD | RD_ABSOLUTE;
		Command[4] = RD_NOEEPROM;

		if( g_pcControllers[Control].fPakInitialized && g_pcControllers[Control].pPakData )
		{
			if( *(BYTE*)g_pcControllers[Control].pPakData == PAK_ADAPTOID )
			{
				Command[5] = GetAdaptoidStatus( Control );

#ifdef ADAPTOIDPAK_RUMBLEFIX
				if( Command[5] & RD_NOTINITIALIZED )
					((ADAPTOIDPAK*)g_pcControllers[Control].pPakData)->fRumblePak = true;
#pragma message( "Driver-fix for Rumble with Adaptoid enabled" )
#endif
			}
			else
			{
				Command[5] = ( *(BYTE*)g_pcControllers[Control].pPakData != PAK_NONE ) ? RD_PLUGIN : RD_NOPLUGIN;
				if( g_pcControllers[Control].fPakCRCError )
				{
					Command[5] = Command[5] | RD_ADDRCRCERR;
					g_pcControllers[Control].fPakCRCError = false;
				}
			}
		}
		else
		{
			if( !g_bConfiguring && InitControllerPak( Control ) && g_pcControllers[Control].pPakData )
			{
				g_pcControllers[Control].fPakInitialized = true;

				if( *(BYTE*)g_pcControllers[Control].pPakData == PAK_ADAPTOID )
					Command[5] = GetAdaptoidStatus( Control );
				else
				{
					Command[5] = ( *(BYTE*)g_pcControllers[Control].pPakData ) ? RD_PLUGIN : RD_NOPLUGIN;
					Command[5] = Command[5] | ( g_pcControllers[Control].fPakCRCError ? RD_ADDRCRCERR : 0 );
				}
			}
			else
				Command[5] = RD_NOPLUGIN | RD_NOTINITIALIZED;
		}

		if( g_pcControllers[Control].fPakCRCError )
		{
			Command[5] = Command[5] | RD_ADDRCRCERR;
			g_pcControllers[Control].fPakCRCError = false;
		}

#ifdef ENABLE_GET_STATUS_DEBUG
		WriteDatasA( "GetStatus-PostProcessing", Command, 0);
		DebugWriteA( NULL );
#endif
		break;

	case RD_READKEYS:
//		WriteDatasA( "ReadKeys-PreProcessing", Command, 0);
		if( g_bConfiguring )
			Command[3] = Command[4] = Command[5] = Command[6] = 0;
		else
		{
			if( g_iFirstController == Control )
				GetDeviceDatas();
			GetNControllerInput( Control, (DWORD*)&Command[3] );
		}
//		WriteDatasA( "ReadKeys-PostProcessing", Command, 0);
//		DebugWriteA( NULL );
		break;
		

	case RD_READPAK:
#ifdef ENABLE_PAK_READS_WRITES_DEBUG
		WriteDatasA( "ReadPak-PreProcessing", Command, 0);
#endif
		if( g_pcControllers[Control].fPakInitialized )
			//Command[1] = Command[1] | ReadControllerPak( Control, &Command[3] );
			ReadControllerPak( Control, &Command[3] );
		//else
			//Command[1] = Command[1] | RD_ERROR;
			//ZeroMemory( &Command[5], 32 );
#ifdef ENABLE_PAK_READS_WRITES_DEBUG
		WriteDatasA( "ReadPak-PostProcessing", Command, 0);
		DebugWriteA( NULL );
#endif
		break;

	case RD_WRITEPAK:
#ifdef ENABLE_PAK_READS_WRITES_DEBUG
		WriteDatasA( "WritePak-PreProcessing", Command, 0);
#endif
		if( g_pcControllers[Control].fPakInitialized )
			//Command[1] = Command[1] | WriteControllerPak( Control, &Command[3] );
			WriteControllerPak( Control, &Command[3] );
		//else
			//Command[1] = Command[1] | RD_ERROR;
#ifdef ENABLE_PAK_WRITES_DEBUG
		WriteDatasA( "WritePak-PostProcessing", Command, 0);
		DebugWriteA( NULL );
#endif
		break;

	case RD_READEEPROM:
		// Should be handled by the Emulator
		WriteDatasA( "ReadEeprom-PreProcessing", Command, 0);
		WriteDatasA( "ReadEeprom-PostProcessing", Command, 0);
		DebugWriteA( NULL );
		break;
	case RD_WRITEEPROM:
		// Should be handled by the Emulator
		WriteDatasA( "WriteEeprom-PreProcessing", Command, 0);
		WriteDatasA( "WriteEeprom-PostProcessing", Command, 0);
		DebugWriteA( NULL );
		break;
		// only accessible if the Emulator has bugs.. or maybe the Rom is flawed
		//MessageBox( g_strEmuInfo.hMainWindow, "This Rom uses EEprom Commands!\nPlease tell me about it", PLUGINERROR, MB_OK );

	default:
		Command[1] = Command[1] | RD_ERROR;
	}

	LeaveCriticalSection( &g_resController );
	return;
}

VOID CALLBACK MessageTimer( HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime )
{
	DWORD dwIterations = GetWindowLong( hwnd, GWL_USERDATA );
	if( dwIterations > 0 )
		SetWindowLong( hwnd, GWL_USERDATA, dwIterations - 1 );
	else
		DestroyWindow( hwnd );
}


EXPORT void CALL WM_KeyDown( WPARAM wParam, LPARAM lParam )
{
	int iMatching = 0;
	if( !(lParam & 0x40000000) && ( wParam != VK_ESCAPE )) // just process if key wasnt pressed before
	{
		for( int i = sizeof(g_scShortcuts) - 1; i >= 0; i-- )
		{
			if( ((BYTE*)&g_scShortcuts)[i] == wParam )
				iMatching++;
		}

	}
	else
		return;

	if( iMatching > 0 && g_bRunning )
	{
		int iPlayerShortcut = -1;
		TCHAR *pszMessage = NULL;
		// main ShortCuts
		int iPlayer = -1;

		if( g_scShortcuts.bMouseLock == wParam && g_apInputDevice[DID_MOUSE] )
		{
			EnterCriticalSection( &g_resController );
			g_apInputDevice[DID_MOUSE]->Unacquire();
			if( g_bExclusiveMouse )
			{
				g_apInputDevice[DID_MOUSE]->SetCooperativeLevel( g_strEmuInfo.hMainWindow, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND );
				pszMessage = "Mouse Unlocked";
			}
			else
			{
				g_apInputDevice[DID_MOUSE]->SetCooperativeLevel( g_strEmuInfo.hMainWindow, DISCL_EXCLUSIVE | DISCL_FOREGROUND );
				pszMessage = "Mouse Locked";
			}
			g_apInputDevice[DID_MOUSE]->Acquire();
			g_bExclusiveMouse = !g_bExclusiveMouse;
			LeaveCriticalSection( &g_resController );
		}

		if( pszMessage )
			iPlayerShortcut = -2;

		// Player ShortCuts
		for( iPlayer = 0; iPlayer < 4; iPlayer++ )
		{
			if( g_pcControllers[iPlayer].fPlugged )
			{
				if( g_scShortcuts.Player[iPlayer].bNoPak == wParam )
				{
					EnterCriticalSection( &g_resController );
					g_pcControllers[iPlayer].PakType = PAK_NONE;
					g_pcControllers[iPlayer].fPakInitialized = false;
					pszMessage = "No";
					LeaveCriticalSection( &g_resController );
				}

				if( g_scShortcuts.Player[iPlayer].bMemPak == wParam )
				{
					EnterCriticalSection( &g_resController );
					g_pcControllers[iPlayer].PakType = PAK_MEM;
					g_pcControllers[iPlayer].fPakInitialized = false;
					pszMessage = "Mem";
					LeaveCriticalSection( &g_resController );
				}

				if( g_scShortcuts.Player[iPlayer].bRumblePak == wParam )
				{
					EnterCriticalSection( &g_resController );
					g_pcControllers[iPlayer].PakType = PAK_RUMBLE;
					g_pcControllers[iPlayer].fPakInitialized = false;

					if( !g_pcControllers[iPlayer].fRawData )
						CreateEffectHandle( iPlayer, g_pcControllers[iPlayer].bRumbleTyp, g_pcControllers[iPlayer].bRumbleStrength );

					pszMessage = "Rumble";
					LeaveCriticalSection( &g_resController );
				}

				if( g_scShortcuts.Player[iPlayer].bTransferPak == wParam )
				{
					EnterCriticalSection( &g_resController );
					g_pcControllers[iPlayer].PakType = PAK_TRANSFER;
					g_pcControllers[iPlayer].fPakInitialized = false;

					pszMessage = "Transfer";
					LeaveCriticalSection( &g_resController );
				}

				if( g_scShortcuts.Player[iPlayer].bVoicePak == wParam )
				{
					EnterCriticalSection( &g_resController );
					g_pcControllers[iPlayer].PakType = PAK_VOICE;
					g_pcControllers[iPlayer].fPakInitialized = false;

					pszMessage = "Voice";
					LeaveCriticalSection( &g_resController );
				}

				if( g_scShortcuts.Player[iPlayer].bAdaptoidPak == wParam )
				{
					EnterCriticalSection( &g_resController );
					g_pcControllers[iPlayer].PakType = PAK_ADAPTOID;
					g_pcControllers[iPlayer].fPakInitialized = false;

					pszMessage = "Adaptoid";
					LeaveCriticalSection( &g_resController );
				}

				if( g_scShortcuts.Player[iPlayer].bSwMemRumble == wParam )
				{
					EnterCriticalSection( &g_resController );
					if( g_pcControllers[iPlayer].PakType == PAK_MEM )
					{
						g_pcControllers[iPlayer].PakType = PAK_RUMBLE;
						
						if( !g_pcControllers[iPlayer].fRawData )
							CreateEffectHandle( iPlayer, g_pcControllers[iPlayer].bRumbleTyp, g_pcControllers[iPlayer].bRumbleStrength );

						pszMessage = "Rumble";
					}
					else
					{
						g_pcControllers[iPlayer].PakType = PAK_MEM;
						pszMessage = "Mem";
					}
					g_pcControllers[iPlayer].fPakInitialized = false;
					LeaveCriticalSection( &g_resController );
				}

				if( g_scShortcuts.Player[iPlayer].bSwMemAdaptoid == wParam )
				{
					EnterCriticalSection( &g_resController );
					if( g_pcControllers[iPlayer].PakType == PAK_MEM )
					{
						g_pcControllers[iPlayer].PakType = PAK_ADAPTOID;
						pszMessage = "Adaptoid";
					}
					else
					{
						g_pcControllers[iPlayer].PakType = PAK_MEM;
						pszMessage = "Mem";
					}
					g_pcControllers[iPlayer].fPakInitialized = false;
					LeaveCriticalSection( &g_resController );
				}
				if( pszMessage && iPlayerShortcut == -1 )
					iPlayerShortcut = iPlayer;
			}
		}
		if( pszMessage )
		{
			EnterCriticalSection( &g_resController );
			NotifyEmulator();
			LeaveCriticalSection( &g_resController );

#ifdef SHOWSHORTCUTMESSAGES
			TCHAR szMessage[40];
			if( iPlayerShortcut >= 0 )
				wsprintf( szMessage, "Player %i:\nChanged to %s Pak", iPlayerShortcut+1, pszMessage );
			else
				lstrcpy( szMessage, pszMessage );

			HWND hMessage = CreateWindowEx( WS_EX_NOPARENTNOTIFY | WS_EX_STATICEDGE | WS_EX_TOPMOST, "STATIC", szMessage, WS_CHILD | WS_VISIBLE, 10, 10, 200, 30, g_strEmuInfo.hMainWindow, NULL, 0, NULL );
			SetWindowLong( hMessage, GWL_USERDATA, 20 );
			SetTimer( hMessage, TIMER_MESSAGEWINDOW, 100, MessageTimer );
#endif // #ifdef SHOWSHORTCUTMESSAGES
		}
	}

	return;
}

EXPORT void CALL WM_KeyUp( WPARAM wParam, LPARAM lParam )
{
	return;
}

EXPORT void CALL CloseDLL (void)
{
	if( g_bRunning )
		RomClosed();
	for( int i = 0; i < 4; i++ )
		freeControllerStruct( &g_pcControllers[i] );
	ZeroMemory( g_pcControllers, sizeof(g_pcControllers) );
	
	FreeDirectInput();

	return;
}

//-------------------------------------------------------------------///////

bool prepareHeap()
{
	if( g_hHeap == NULL )
		g_hHeap = HeapCreate( 0, 4*1024, 0 );
	return (g_hHeap != NULL);
}



void freeControllerStruct( CONTROLLER *pcController )
{
	if( pcController )
	{
		if( pcController->pModifiers )
		{
			pcController->nModifiers = 0;
			P_free( pcController->pModifiers );
			pcController->pModifiers = NULL;
		}
		if( pcController->pPakData )
		{
			P_free( pcController->pPakData );
			pcController->pPakData = NULL;
		}
	}
}

int FindDeviceinList( TCHAR *pszProductName, BYTE bProductCounter, bool fFindSimilar )
{
	if( bProductCounter == (BYTE)-1 )
		return -1;

	int i = 0, iSimilar = -1, iExact = -1;
	while(( i < ARRAYSIZE(g_devList) ) && g_devList[i].dwDevType && ( iExact == -1 ))
	{
		if( !lstrcmp( g_devList[i].szProductName, pszProductName ))
		{
			if(( bProductCounter > 0 ) || ( iSimilar = -1 ))
				iSimilar = i;
			if( g_devList[i].bProductCounter == bProductCounter )
				iExact = i;
		}
		i++;
	}

	if( fFindSimilar && ( iExact == -1 ))
		iExact = iSimilar;

	return iExact;
}

void InitiatePaks( bool bInitialize )
{
	for( int i = 0; i < 4; i++ )
	{
		if( g_pcControllers[i].fPlugged)
		{
			g_pcControllers[i].fPakCRCError = false;
			
			if( g_pcControllers[i].fRawData )
			{
				if( !bInitialize )
					g_pcControllers[i].fPakInitialized = InitControllerPak( i ) != 0;
			}
			else
			{
				if( g_pcControllers[i].PakType == PAK_RUMBLE )
					CreateEffectHandle( i, g_pcControllers[i].bRumbleTyp, g_pcControllers[i].bRumbleStrength );
			}
		}
	}
}

void NotifyEmulator()
{
	if( !g_strEmuInfo.fInitialisedPlugin )
		return;
	g_iFirstController = -1;
	for( int i = 4-1; i >= 0; i-- )
	{
		if( g_pcControllers[i].fPlugged )
		{
			g_strEmuInfo.Controls[i].Present	= g_pcControllers[i].fPlugged;
			if( g_strEmuInfo.Controls[i].Present )
				g_iFirstController = i;
			g_strEmuInfo.Controls[i].RawData	= g_pcControllers[i].fRawData;

			switch( g_pcControllers[i].PakType )
			{
			case PAK_MEM:
				g_strEmuInfo.Controls[i].Plugin = PLUGIN_MEMPAK;
				break;
			case PAK_RUMBLE:
				g_strEmuInfo.Controls[i].Plugin = PLUGIN_RUMBLE_PAK;
				break;
			case PAK_TRANSFER:
				g_strEmuInfo.Controls[i].Plugin = PLUGIN_TANSFER_PAK;
				break;
			case PAK_VOICE:
				g_strEmuInfo.Controls[i].Plugin = g_pcControllers[i].fRawData ? PLUGIN_RAW : PLUGIN_NONE;
				break;
			case PAK_ADAPTOID:
				g_strEmuInfo.Controls[i].Plugin = g_pcControllers[i].fRawData ? PLUGIN_RAW : PLUGIN_NONE;
				break;

			case PAK_NONE:
			default:
				g_strEmuInfo.Controls[i].Plugin = PLUGIN_NONE;
			}	
		}
		else
		{
			g_strEmuInfo.Controls[i].Plugin	= PLUGIN_NONE;
			g_strEmuInfo.Controls[i].Present	= false;
			g_strEmuInfo.Controls[i].RawData	= false;
		}
	}
}

bool ErrorMessage( TCHAR *pszFirstLine, DWORD dwError, bool fUserChoose )
{
	bool fReturn = false;;
	TCHAR szError[512];
	int iBytes;

	if( dwError )
	{
		iBytes = wsprintf( szError, "%s\n\n ErrorDescription: ", pszFirstLine );
		FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwError , 0, &szError[iBytes], sizeof(szError) - iBytes, NULL );
	}
	else
		lstrcpy( szError, pszFirstLine );
	
	if( fUserChoose )
		fReturn = MessageBox( g_strEmuInfo.hMainWindow, szError, PLUGINERROR, MB_RETRYCANCEL | MB_ICONERROR ) == IDRETRY;
	else
		MessageBox( g_strEmuInfo.hMainWindow, szError, PLUGINERROR, MB_OK | MB_ICONERROR );

	return fReturn;
}